/*-------------------------------------------------------*
*  Name:      ZHierarchy                                 *
*  Purpose:   Hierarchy emulator for ZModeler v1.06      *
*  Authors:   Oleg M.                                    *
*  History:   29.Jun.2002 - started                      *
*             14.Jul.2002 - Added file:open/save support *
*                                                        *                                                        *
*-------------------------------------------------------*/

#include <Struct.h>
#include <3dEngine.h>

#include "Affector.h"
#include "FloatBar.h"
#include "LinkedList.h"


//-----------------------------------------------------------------
//  DWORD Capabilities - a combination versions
DWORD CALLBACK Capabilities(long)
{
  return ZMODELER_BUILD_VERSION();
}


//-----------------------------------------------------------------
//  DWORD Supports returns a combination of supported features
DWORD CALLBACK Supports(long)
{
  return  Z3D_PLUGSUPPORTS_PROCESSING |
          Z3D_PLUGSUPPORTS_SYSREQUESTS|
          Z3D_PLUGSUPPORTS_SCENEOPENSAVE;
}


//-----------------------------------------------------------------
//  DWORD Restrictions returns a combination of restrictions modes
DWORD CALLBACK Restrictions(long)
{
  return 0; //no restrictions. but it can be Z3D_MODE_DEBUG or other
}


DWORD CALLBACK DynamicLoading(long)
{
  return 0; // DLL will be loaded ones.
}


DWORD CALLBACK PlaceType(DWORD)
{
  return Z3D_PROCPLACE_MAINMENU;
}


DWORD CALLBACK GetProcsAmount(DWORD)
{
  return 2;
}


char* CALLBACK GetProgrammingProcName(DWORD num)
{
  if (num==0) return "Browser...";
  if (num==1) return "Affect Editing";
  return NULL;
}


char* CALLBACK GetProcName(DWORD num)
{
  return GetProgrammingProcName(num);
}



char* CALLBACK GetMenuFolder(DWORD num)
{
  return "&Tools\\Hierarchy\0";
}


DWORD CALLBACK MenuItemType(DWORD num)
{
  if (num == 0)
    return Z3D_PROCTYPE_SINGLECALL;
  else
    return Z3D_PROCTYPE_ONOFFCALLS;
}



DWORD CALLBACK HierarchyOnSceneRebuild(tProcParams* params)
{
  //update dependences
  return 0;
}


DWORD CALLBACK BrowserActivate(tProcParams* params)
{
  char* pszError = NULL;
  if (!ValidateList(pszError))
  {
    CurrentState.SetMessage(pszError);
    AfxMessageBox(pszError);
    free(pszError);
    return Z3D_PLUGRESULT_UPDATEMESSAGE;
  }
  AfxSetResourceHandle(params->DllHandle);
  g_dllHandle = params->DllHandle;

  CHierarchyBar dlg(AfxGetMainWnd());
  dlg.DoModal();
  AfxSetResourceHandle(params->AppHandle);

  return 0;
}



DWORD CALLBACK AffectEditingActivate(tProcParams* params)
{
  //add tool to the list of resident tools
  params->ListSet->AddProc(
        Z3D_EVENT_MM,
        HIERARCY_EDITING_AFFECTOR,
        NULL,
        (PLUGPROCESSORPROC)AffectorMM,
        NULL,
        NULL,
        params,
        params->DllHandle);
  params->ListSet->AddProc(
        Z3D_EVENT_LBD | Z3D_EVENT_RBD,
        HIERARCY_EDITING_AFFECTOR,
        (PLUGPROCESSORPROC)AffectorBD,
        NULL,
        NULL,
        NULL,
        params,
        params->DllHandle);
  params->ListSet->AddProc(
        Z3D_EVENT_LBU | Z3D_EVENT_RBU,
        HIERARCY_EDITING_AFFECTOR,
        (PLUGPROCESSORPROC)AffectorBU,
        NULL,
        NULL,
        NULL,
        params,
        params->DllHandle);
  return 0;
}


DWORD CALLBACK AffectEditingDeactivate(tProcParams* params)
{
  params->ListSet->RemoveProc(
        Z3D_EVENT_LBD | Z3D_EVENT_RBD | Z3D_EVENT_LBU | Z3D_EVENT_RBU | Z3D_EVENT_MM,
        HIERARCY_EDITING_AFFECTOR,
        params);
  return 0;
}



DWORD CALLBACK PluginUnload(tProcParams* params)
{
  //write profile
  if (g_pHList)
    DeleteList(g_pHList);
  return 0;
}


//-------------------------------------
// Load hierarchy data
DWORD CALLBACK ReadChunk(tProcParams* params)
{
  if (0x8020 == params->reserv)
  {
    CFile* pFile = (CFile*)params->pDATA;
    if (!pFile)
      return 0;
    return Load(pFile);
  }
  return 0;
}

//-------------------------------------
// Save hierarchy data
DWORD CALLBACK WriteChunks(tProcParams* params)
{
  CFile* pFile = (CFile*)params->pDATA;
  if (!pFile)
    return 0;

  return Save(pFile);
}
